package com.uca.gui;

import com.uca.core.PokemonCore;
import com.uca.core.UserCore;
import com.uca.entity.UserEntity;
import com.uca.exceptions.ServiceException;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PokemonGUI {

    public static String getAllPokemons(UserEntity connectedUser) throws IOException, TemplateException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("pokemons", PokemonCore.getAll());
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "pokemons/pokemons.ftl");
    }

    public static String getPokemon(UserEntity connectedUser, int id) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("pokemon", PokemonCore.getById(id));
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "pokemons/pokemon.ftl");
    }
}
