package com.uca.gui;

import com.uca.core.ExchangeCore;
import com.uca.core.PokemonCore;
import com.uca.core.UserCore;
import com.uca.entity.UserEntity;
import com.uca.exceptions.ServiceException;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExchangeGUI {
    public static String getAllExchanges(UserEntity connectedUser) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("exchanges", ExchangeCore.getAll());
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "exchanges/exchanges.ftl");
    }

    public static String getAllByExp(UserEntity connectedUser, int idUserExp) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("exp", UserCore.getById(idUserExp));
            input.put("exchanges", ExchangeCore.getAllByUserExp(idUserExp));
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "exchanges/exchanges-exp.ftl");
    }

    public static String getAllByDest(UserEntity connectedUser, int idUserDest) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("dest", UserCore.getById(idUserDest));
            input.put("exchanges", ExchangeCore.getAllByUserDest(idUserDest));
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "exchanges/exchanges-dest.ftl");
    }

    public static String getExchange(UserEntity connectedUser, int id) throws TemplateException, IOException {
        Map<String, Object> input = new HashMap<>();
        input.put("connectedUser", connectedUser);

        try {
            input.put("exchange", ExchangeCore.getById(id));
        } catch (ServiceException e) {
            input.put("error", e.getMessage());
        }

        return _Factory.genericGUI(input, "exchanges/exchange.ftl");
    }
}
