package com.uca.dao;

import com.uca.exceptions.ServiceException;

import java.sql.Connection;
import java.util.ArrayList;

public abstract class _Generic<T> {

    public Connection connect = _Connector.getInstance();

    /**
     * Permet d'obtenir toutes les entrées de la table
     */
    public abstract ArrayList<T> getAll() throws ServiceException;

    public abstract T getById(int id) throws ServiceException;

    /**
     * Permet de mettre à jour une des entrées de la base
     * @param id L'identifiant de l'objet à modifier
     * @param obj L'objet qui contient les nouvelles propriétés
     */
    public abstract void update(int id, T obj) throws ServiceException;

    /**
     * Permet de créer une entrée dans la base de données
     * par rapport à un objet
     * @param obj
     */
    public abstract T create(T obj) throws ServiceException;

    /**
     * Permet la suppression d'une entrée de la base
     * @param id
     */
    public abstract void delete(int id) throws ServiceException;

}
