package com.uca.core;

import com.uca.dao.PokedexDAO;
import com.uca.dao.PokemonDAO;
import com.uca.entity.PokedexEntity;
import com.uca.entity.PokemonEntity;
import com.uca.entity.UserEntity;
import com.uca.exceptions.ServiceException;

import java.util.ArrayList;

public class PokemonCore {
    private static final PokemonDAO pokemonDAO = new PokemonDAO();
    private static final PokedexDAO pokedexDAO = new PokedexDAO();

    public static ArrayList<PokemonEntity> getAll() throws ServiceException {
        return pokemonDAO.getAll();
    }

    public static ArrayList<PokemonEntity> getAllByOwner(int idOwner) throws ServiceException {
        return pokemonDAO.getAllByOwner(idOwner);
    }

    public static PokemonEntity getById(int id) throws ServiceException {
        PokemonEntity entity = pokemonDAO.getById(id);

        if (entity.getId() == 0) {
            throw new ServiceException("This pokemon does not exist");
        }

        return entity;
    }

    public static PokedexEntity getPokedexById(int idAPI) throws ServiceException {
        PokedexEntity entity = pokedexDAO.getById(idAPI);

        if (entity.getId() == 0) {
            throw new ServiceException("This species of pokemon does not exist");
        }

        return entity;
    }

    public static PokemonEntity create(PokedexEntity species, String nickname, int level, UserEntity owner) throws ServiceException {
        PokemonEntity entity = new PokemonEntity();
        entity.setSpecies(species);
        entity.setNickname(nickname);
        entity.setLevel(level);
        entity.setOwner(owner);

        return pokemonDAO.create(entity);
    }

    public static void update(int id, PokedexEntity species, String nickname, int level, UserEntity owner) throws ServiceException {
        PokemonEntity entity = new PokemonEntity();
        entity.setSpecies(species);
        entity.setNickname(nickname);
        entity.setLevel(level);
        entity.setOwner(owner);

        pokemonDAO.update(id, entity);
    }

    public static void delete(int id) throws ServiceException {
        pokemonDAO.delete(id);
    }
}
