package com.uca.core;

import com.uca.dao.ExchangeDAO;
import com.uca.entity.ExchangeEntity;
import com.uca.entity.PokemonEntity;
import com.uca.exceptions.ServiceException;

import javax.swing.*;
import java.util.ArrayList;

public class ExchangeCore {
    private static final ExchangeDAO exchangeDAO = new ExchangeDAO();

    public static ArrayList<ExchangeEntity> getAll() throws ServiceException {
        return exchangeDAO.getAll();
    }

    public static ArrayList<ExchangeEntity> getAllByUserExp(int idExp) throws ServiceException {
        return exchangeDAO.getAllByUserExp(idExp);
    }

    public static ArrayList<ExchangeEntity> getAllByUserDest(int idDest) throws ServiceException {
        return exchangeDAO.getAllByUserDest(idDest);
    }

    public static ExchangeEntity getById(int id) throws ServiceException {
        ExchangeEntity entity = exchangeDAO.getById(id);

        if (entity.getId() == 0) {
            throw new ServiceException("This exchange does not exist");
        }

        return entity;
    }

    public static ExchangeEntity create(PokemonEntity exp, PokemonEntity dest, String status) throws ServiceException {
        ExchangeEntity entity = new ExchangeEntity();
        entity.setPokemonExp(exp);
        entity.setPokemonDest(dest);
        entity.setStatus(status);

        return exchangeDAO.create(entity);
    }

    public static void update(int id, PokemonEntity exp, PokemonEntity dest, String status) throws ServiceException {
        ExchangeEntity entity = new ExchangeEntity();
        entity.setPokemonExp(exp);
        entity.setPokemonDest(dest);
        entity.setStatus(status);

        exchangeDAO.update(id, entity);
    }

    public static void delete(int id) throws ServiceException {
        exchangeDAO.delete(id);
    }
}
