# TP Web-Serveur : Pokémon Collector

> Le rapport du projet se trouve dans le fichier `rapport.pdf`.

Le serveur peut être démarré avec la commande `./gradlew run`.

Le site est alors accessible à l'adresse suivante : `http://localhost:8081/`

En cas de dysfonctionnement, il est possible de réinitialiser la base de données du site. Pour cela, il suffit de supprimer le fichier `test.mv.db` du répertoire personnel.

Au premier lancement, ou après une réinitialisation, un utilisateur `admin` et un mot de passe seront créés automatiquement. Il reste malgré tout possible de créer de nouveaux utilisateurs depuis le site en cliquant sur "S'inscrire" dans le menu.

## Réponses aux questions du TP 1

NOTRE VERSION:
1  - Quelles sont les fonctionnalités qui vous semblent importantes ?

    - Pouvoir se connecter / déconnecter
    - S'inscrire / Se désinscrire
    - Inscription: obtention d'un Pokémon aléatoire
    (- Pouvoir accéder à son Pokédex (liste des Pokémons avec leurs  caractéristiques propores + niveau du Pokémon))
    - Détecter la première connexion de la journée + obtention d'un Pokémon (aléatoire) + possibilité de monté 5 Pokémon de 1 niveau par jour
    - système d'échange de Pokémon: 1 Pokémon échangé avec 1 Pokémon (avec nimporte quel utilisateur)


2 - Quelles vont être les principales classes de votre application ?
    class: user, pokemon, trade, (une classe pour le Pokédex)

3 - Quelles vont être les tables de votre base de données ? Vous pouvez produire un diagramme UML pour mettre au clair les jointures entre les tables, mais c'est facultatif.

    USERS:
    email
    username
    password
    name

    POKEDEX:
    id_Pokemon
    name
    type
    ...

    LIST:
    email
    id_Pokemon
    level
    id_couple


4 - Quelles solutions technologiques envisagez vous ?
    Java, SQLite


CORRECTION:
1  - Quelles sont les fonctionnalités qui vous semblent importantes ?

    - Se conneceter sur le site et étiqueté la date de la connection;
    - se déconnecter;
    - S'inscrire sur le site;
    - gérer un Pokémon aléatoire;
    - affecter (=ajouter) un Pokémon à un utilisateur;
    - gérer les échanges de Pokémons;
    - augmenter le niveau de 5 Pokémons par jour;
    - voir la liste des Pokémons;

2 - Quelles vont être les principales classes de votre application ?
    Cf image 

3 - Quelles vont être les tables de votre base de données ? Vous pouvez produire un diagramme UML pour mettre au clair les jointures entre les tables, mais c'est facultatif.

    Utilisateurs:
    id (P)
    firstname
    lastname
    motdepasse
    email (ou P)

    Pokedex: (optionnel)
    id_API
    name
    ...

    UtilistateurPokemon:
    id_Utilisateur (P #)
    id_Pokemon (P #)

    ListePokemons
    id_Pokemon (P)
    id_API (#)
    level
    surnom

(On peut rajouter une table pour enregistrer les échanges de pokémon et ainsi garder un historique des échanges)

4 - Quelles solutions technologiques envisagez vous ?
    Base de Données SQL
    JavaSpark
    freeMarker
    API Pokémon
    HTML/CSS: interface
