/**
 * @file main.c
 * @brief Contients l'appel au différente focntion d'interpolation et de regression.
 * @author Valentin PORTAIL et Jérémie VILLEPREUX
 * @version 1.0
 * @date 10/11/2022
 */

#include "interpolation.h"
#include "gestionFichier.h"
#include "approximation.h"

#include <time.h>

int main() {
    time_t debut;
    time_t fin;
    double temps;

    // // Jeu 1
    printf("Début des points de la série \"Densité de l'eau/température\" : \n [x] | [y]\n");
    double ** points1 = lecture_points("polynome1.txt", NOMBRES_POINTS_1);
    printf("---------------------\nFin des poitns de la série.\n\n");

    // Lagrange

    debut = clock();
    ecriture_polynome_L("polynome1_L.txt", points1, NOMBRES_POINTS_1, -0.5, 38.5);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 1 : Temps pour Lagrange : %lf\n", temps);

    // Neville

    debut = clock();
    ecriture_polynome_N("polynome1_N.txt", points1, NOMBRES_POINTS_1, -0.5, 38.5);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 1 : Temps pour Neville : %lf\n", temps);

    freeMat(points1, NOMBRES_POINTS_1);

    printf("\n");

    
    // // Jeu 2
    printf("Début des points de la série \"Dépenses mensuelles et revenus\": \n [x] | [y]\n");
    double ** points2 = lecture_points("polynome2.txt", NOMBRES_POINTS_2);
    printf("---------------------\nFin des poitns de la série.\n\n");
    
    debut = clock();
    ecriture_polynome_L("polynome2_L.txt", points2, NOMBRES_POINTS_2, 450, 922);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 2 : Temps pour Lagrange : %lf\n", temps);

    debut = clock();
    ecriture_polynome_N("polynome2_N.txt", points2, NOMBRES_POINTS_2, 450, 922);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 2 : Temps pour Neville : %lf\n", temps);

    freeMat(points2, NOMBRES_POINTS_2);

    printf("\n");

    
    //Jeu 3
    printf("Début des points de la série \"S\" : \n [x] | [y]\n");
    double ** points3 = lecture_points("polynome3.txt", NOMBRES_POINTS_3);
    printf("---------------------\nFin des poitns de la série.\n\n");
    
    debut = clock();
    ecriture_polynome_L("polynome3_L.txt", points3, NOMBRES_POINTS_3, 3.5, 14.8);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 3 : Temps pour Lagrange : %lf\n", temps);

    debut = clock();
    ecriture_polynome_N("polynome3_N.txt", points3, NOMBRES_POINTS_3, 3.5, 14.8);
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 3 : Temps pour Neville : %lf\n", temps);

    freeMat(points3, NOMBRES_POINTS_3);




    //approximation


    //Jeu 1
    printf("Regression linéaire pour la série \"Densité de l'eau/température\" :");
    float *pointsxA = lecture_colonne("polynome1.txt",0, NOMBRES_POINTS_1);
    float *pointsyA = lecture_colonne("polynome1.txt",1, NOMBRES_POINTS_1);
   
    debut = clock();
    ecriture_points_approx("polynome1_A.txt", approximation(pointsxA, pointsyA, NOMBRES_POINTS_1));
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 1 : Temps pour Approximation : %lf\n", temps);

    libere_tab_1d(pointsxA);
    libere_tab_1d(pointsyA);

    
    //Jeu 2
    printf("Regression linéaire pour la série \"Dépenses mensuelles et revenus\" :");

    float *pointsxB = lecture_colonne("polynome2.txt",0, NOMBRES_POINTS_2);
    float *pointsyB = lecture_colonne("polynome2.txt",1, NOMBRES_POINTS_2);
   
    debut = clock();
    ecriture_points_approx("polynome2_A.txt", approximation(pointsxB, pointsyB, NOMBRES_POINTS_2));
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 2 : Temps pour Approximation : %lf\n", temps);

    libere_tab_1d(pointsxB);
    libere_tab_1d(pointsyB);

    
    //Jeu 3
    printf("Regression linéaire pour la série \"S\" :");
    float *pointsxC = lecture_colonne("polynome3.txt",0, NOMBRES_POINTS_3);
    float *pointsyC = lecture_colonne("polynome3.txt",1, NOMBRES_POINTS_3);
   
    debut = clock();
    ecriture_points_approx("polynome3_A.txt", approximation(pointsxC, pointsyC, NOMBRES_POINTS_3));
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 3 : Temps pour Approximation : %lf\n", temps);

    libere_tab_1d(pointsxC);
    libere_tab_1d(pointsyC);	


    //Jeu 4
    printf("Regression linéaire pour la vérification de la loi de Pareto :");
    float *pointsxD = lecture_colonne("polynome4.txt",0, NOMBRES_POINTS_4);
    float *pointsyD = lecture_colonne("polynome4.txt",1, NOMBRES_POINTS_4);
   
    debut = clock();
    ecriture_points_approx("polynome4_A.txt", approximation_exp(pointsxD, pointsyD, NOMBRES_POINTS_4));
    fin = clock();

    temps = (double) (fin - debut) / CLOCKS_PER_SEC;
    printf("Jeu 4 : Temps pour Approximation : %lf\n", temps);

    libere_tab_1d(pointsxD);
    libere_tab_1d(pointsyD);
    
    return EXIT_SUCCESS;
}

