/**
 * @file gestionFichier.h
 * @brief Contients les portotypes des fonctions de gestions des fichiers.
 * @author Valentin PORTAIL et Jérémie VILLEPREUX
 * @version 1.0
 * @date 08/11/2022
 */

#ifndef __GESTION_FICHIER_H
#define __GESTION_FICHIER_H

#include <stdio.h>
#include <stdlib.h>
#include<string.h>

/** \def NOMBRES_POINTS_1
 * @brief Correspond au nombre de points pour le jeu de données 1.
 */
#define NOMBRES_POINTS_1 20

/** \def NOMBRES_POINTS_2
 * @brief Correspond au nombre de points pour le jeu de données 2.
 */
#define NOMBRES_POINTS_2 21

/** \def NOMBRES_POINTS_3
 * @brief Correspond au nombre de points pour le jeu de données 3.
 */
#define NOMBRES_POINTS_3 11

/** \def NOMBRES_POINTS_4
 * @brief Correspond au nombre de points pour le jeu de données 4.
 */
#define NOMBRES_POINTS_4 7


double ** matrice(unsigned int, unsigned int);

void freeMat(double **, unsigned int);

FILE * ouvertureFichier(char *, char*);

void fermetureFichier(FILE *);

void ecriture_points(char *, double, double);

float *lecture_colonne(char *, int, int);

double ** lecture_points(char *, unsigned int);

void ecriture_points_approx(char *, float *);
#endif
