/**
 * @file main.c
 * @brief Contients l'appel à toute les fonctions pour résoudre les sytèmes avec les matrices tests proposées.
 * @author Valentin PORTAIL et Jérémie VILLEPREUX
 * @version 1.0
 * @date 02/10/2022
 */

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include"matriceTest.h"
#include"gauss.h"



/* ======================================================================
   CETTE PARTIE N'EST JUSTE QU'UN MENU POUR LE CHOIX DES MATRICES TESTS
   **********************************************************
    
   Nous avons décidé d'implémenter le choix de la matrice à l'aide d'un
   'switch'.
   Le code peut paraître assez lourd, mais il se contente d'appeler et
   d'appliquer la méthode de Gauss à la matrice test sélectionné, ainsi que
   d'afficher les matrices du sytème, du second membre du sytème et l'unique 
   matrice solution.
   ====================================================================== */



int main(){

    int choix=0;

    printf("Bienvenu,\n\n");
    printf("Le menu suivant propose d'appliquer la méthode de Gauss sur les différentes matrices tests proposées.\n");
    printf("\t> Le premier chiffre du menu correspond au numéro de la matrice proposées.\n");

    printf("\t> Le second (et troisième) chiffre (non nécessaire pour les choix 1 à 4), correspond à la taille de départ pour les matrices A5 et A6.\n");

    printf("Par exemple :\n");
    printf("\t >>> Le choix '3' va appliquer la méthode de Gauss à la matrice A3.\n");
    printf("\t >>> Le choix '56' va appliquer la méthode de Gauss à la matrice A5 en dimension 6.\n");

    printf("\n\n");


    printf("Menu:\n");
    printf("1. Applique la méthode de Gauss à la matrice A1.\n");
    printf("2. Applique la méthode de Gauss à la matrice A2.\n");
    printf("3. Applique la méthode de Gauss à la matrice A3.\n");
    printf("4. Applique la méthode de Gauss à la matrice A4.\n");
    printf("53. Applique la méthode de Gauss à la matrice A5 en taille 3.\n");
    printf("56. Applique la méthode de Gauss à la matrice A5 en taille 6.\n");
    printf("58. Applique la méthode de Gauss à la matrice A5 en taille 8.\n");
    printf("510. Applique la méthode de Gauss à la matrice A5 en taille 10.\n");
    printf("63. Applique la méthode de Gauss à la matrice A6 en taille 3.\n");
    printf("66. Applique la méthode de Gauss à la matrice A6 en taille 6.\n");
    printf("68. Applique la méthode de Gauss à la matrice A6 en taille 6.\n");
    printf("610. Applique la méthode de Gauss à la matrice A6 en taille 10.\n");

    printf("Quel est votre choix ? ");

    scanf("%d", &choix);

    switch(choix){
	
    case 1:{
	// MATRICE A1
	double **A1=matriceA1Dynamique();
	printf("La matrice A de départ est: \n");
	afficheMatrice(A1, TAILLE_MATRICE, TAILLE_MATRICE);
	double **B1=matriceB1Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B1, TAILLE_MATRICE, 1);
	double **X1=methodeDeGauss(A1, TAILLE_MATRICE, B1, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X1, TAILLE_MATRICE, 1);

	liberationMemoireMatrice(A1, TAILLE_MATRICE);
	liberationMemoireMatrice(B1, TAILLE_MATRICE);
	liberationMemoireMatrice(X1, TAILLE_MATRICE);   
	break;
    }

	    
    case 2:{
	// MATRICE A2    
	double **A2=matriceA2Dynamique();
	printf("La matrice A de départ est: \n");
	afficheMatrice(A2, TAILLE_MATRICE, TAILLE_MATRICE);
	double**B2=matriceB2Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B2, TAILLE_MATRICE, 1);
	double **X2=methodeDeGauss(A2, TAILLE_MATRICE, B2, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X2, TAILLE_MATRICE, 1);

	liberationMemoireMatrice(A2, TAILLE_MATRICE);
	liberationMemoireMatrice(B2, TAILLE_MATRICE);
	liberationMemoireMatrice(X2, TAILLE_MATRICE);
	break;
    }

	    
    case 3:{
	// MATRICE A3
	double **A3=matriceA3Dynamique();
	printf("La matrice A de départ est: \n");
	afficheMatrice(A3, TAILLE_MATRICE, TAILLE_MATRICE);
	double**B3=matriceB3Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B3, TAILLE_MATRICE, 1);
	double **X3=methodeDeGauss(A3, TAILLE_MATRICE, B3, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X3, TAILLE_MATRICE, 1);

	liberationMemoireMatrice(A3, TAILLE_MATRICE);
	liberationMemoireMatrice(B3, TAILLE_MATRICE);
	liberationMemoireMatrice(X3, TAILLE_MATRICE);
	break;
    }
	    
	    
    case 4:{
	// MATRICE A4    
	double **A4=matriceA4Dynamique();
	printf("La matrice A de départ est: \n");
	afficheMatrice(A4, TAILLE_MATRICE, TAILLE_MATRICE);
	double**B4=matriceB4Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B4, TAILLE_MATRICE, 1);
	double **X4=methodeDeGauss(A4, TAILLE_MATRICE, B4, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X4, TAILLE_MATRICE, 1);

	liberationMemoireMatrice(A4, TAILLE_MATRICE);
	liberationMemoireMatrice(B4, TAILLE_MATRICE);
	liberationMemoireMatrice(X4, TAILLE_MATRICE);
	break;
    }

	    
    case 53:{
	
	// MATRICE A5_3    
	double **A5_3=matriceA5Dynamique(TAILLE_MATRICE);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A5_3, TAILLE_MATRICE, TAILLE_MATRICE);
	double**B5_3=matriceB5_3Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B5_3, TAILLE_MATRICE, 1);
	double **X5_3=methodeDeGauss(A5_3, TAILLE_MATRICE, B5_3, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X5_3, TAILLE_MATRICE, 1);

	liberationMemoireMatrice(A5_3, TAILLE_MATRICE);
	liberationMemoireMatrice(B5_3, TAILLE_MATRICE);
	liberationMemoireMatrice(X5_3, TAILLE_MATRICE);
	break;
    }

	    
    case 56:{
	// MATRICE A5_6    
	double **A5_6=matriceA5Dynamique(6);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A5_6, 6, 6);
	double**B5_6=matriceB5_6Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B5_6, 6, 1);
	double **X5_6=methodeDeGauss(A5_6, 6, B5_6, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X5_6, 6, 1);
    
	liberationMemoireMatrice(A5_6, 6);
	liberationMemoireMatrice(B5_6, 6);
	liberationMemoireMatrice(X5_6, 6);
	break;
    }

	    
    case 58:{
	// MATRICE A5_8    
	double **A5_8=matriceA5Dynamique(8);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A5_8, 8, 8);
	double**B5_8=matriceB5_8Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B5_8, 8, 1);
	double **X5_8=methodeDeGauss(A5_8, 8, B5_8, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X5_8, 8, 1);
    
	liberationMemoireMatrice(A5_8, 8);
	liberationMemoireMatrice(B5_8, 8);
	liberationMemoireMatrice(X5_8, 8);
	break;
    }
	    

    case 510:{
	
    
	// MATRICE A5_10    
	double **A5_10=matriceA5Dynamique(10);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A5_10, 10, 10);
	double**B5_10=matriceB5_10Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B5_10, 10, 1);
	double **X5_10=methodeDeGauss(A5_10, 10, B5_10, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X5_10, 10, 1);

	liberationMemoireMatrice(A5_10, 10);
	liberationMemoireMatrice(B5_10, 10);
	liberationMemoireMatrice(X5_10, 10);
	break;
    }
	    

    case 63:{
	// MATRICE A6_3    
	double **A6_3=matriceA6Dynamique(TAILLE_MATRICE);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A6_3, TAILLE_MATRICE, TAILLE_MATRICE);
	double**B6_3=matriceB6_3Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B6_3, TAILLE_MATRICE, 1);
	double **X6_3=methodeDeGauss(A6_3, TAILLE_MATRICE, B6_3, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X6_3, TAILLE_MATRICE, 1);
    
	liberationMemoireMatrice(A6_3, TAILLE_MATRICE);
	liberationMemoireMatrice(B6_3, TAILLE_MATRICE);
	liberationMemoireMatrice(X6_3, TAILLE_MATRICE);
	break;
    }

	    
    case 66:{
	// MATRICE A6_6    
	double **A6_6=matriceA6Dynamique(6);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A6_6, 6, 6);
	double**B6_6=matriceB6_6Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B6_6, 6, 1);
	double **X6_6=methodeDeGauss(A6_6, 6, B6_6, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X6_6, 6, 1);

	liberationMemoireMatrice(A6_6, 6);
	liberationMemoireMatrice(B6_6, 6);
	liberationMemoireMatrice(X6_6, 6);
	break;
    }
	    
    case 68:{
	// MATRICE A6_8    
	double **A6_8=matriceA6Dynamique(8);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A6_8, 8, 8);
	double**B6_8=matriceB6_8Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B6_8, 8, 1);
	double **X6_8=methodeDeGauss(A6_8, 8, B6_8, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X6_8, 8, 1);
    
	liberationMemoireMatrice(A6_8, 8);
	liberationMemoireMatrice(B6_8, 8);
	liberationMemoireMatrice(X6_8, 8);
	break;
    }

    case 610:{
	// MATRICE A6_10    
	double **A6_10=matriceA6Dynamique(10);
	printf("La matrice A de départ est: \n");
	afficheMatrice(A6_10, 10, 10);
	double**B6_10=matriceB6_10Dynamique();
	printf("La matrice b de départ est: \n");
	afficheMatrice(B6_10, 10, 1);
	double **X6_10=methodeDeGauss(A6_10, 10, B6_10, pow(10, -15));
	printf("La matrice final x est: \n");
	afficheMatrice(X6_10, 10, 1);
    
	liberationMemoireMatrice(A6_10, 10);
	liberationMemoireMatrice(B6_10, 10);
	liberationMemoireMatrice(X6_10, 10);
	break;
    }

    default:
	printf("Erreur de saisie. \n");	
    }
    printf("Fin du programme.\n");
    return EXIT_SUCCESS;
}
